---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
aliases:
  - Adjacency
  - Incidence
---

# Adjacency : Incidence (relation)

> Which interfaces touch; direct interaction is possible.

---

## Definition

- Interface contact state
- Touch relationship
- Direct connection
- Immediate access

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Interface touch | Port connect | `Monitor`, `Touch` |
| Direct link | Next hop | `Check`, `Link` |
| Close access | Near node | `Test`, `Near` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Interface touch | Can reach | "Touches it" |
| Direct link | Next to | "Right there" |
| Close access | Can get to | "Direct path" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Port connect | Can reach | How touch works |
| Next hop | Next to | How near forms |
| Near node | Can get to | How access flows |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Surface touch | Force reach |
| Networks | Link direct | Node near |
| Cognition | Mind touch | Think near |
| Systems | State next | Flow touch |

---

## Scale Effects

How Adjacency manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum touch | Wave near |
| λV | Gate next | State touch |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase near | Pattern touch |
| ∇S | Structure next | Clear near |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave next | Light touch |
| λV | Field near | Space next |

Note: At extreme scales, adjacency faces fundamental limits (e.g., quantum uncertainty at ε, causal touch at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: touch resolution
- c: reach limit
- ψA: phase touch
- λV: gate near

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern next | Wave touch |
| Human | λV | Gate near | Flow next |
| Cosmic | ψA | Phase touch | Field near |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Miss touch | Pattern gap | Not there |
| Human | False near | Bad link | Wrong touch |
| Cosmic | Lost next | Field gap | No reach |

---

## Diagnostic Checklist

Technical tests:
- [ ] Touch checked
- [ ] Link direct
- [ ] Near clear
- [ ] Access works

Humane tests:
- [ ] Can reach
- [ ] Right there
- [ ] Path clear
- [ ] Gets there

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical adjacency nor experiential nearness alone captures its full meaning.

---

## See Also

- [[Containment : Embedding (relation)]]
- [[Dependency : Constraint (relation)]]
- [[Bridge : Articulation (relation)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented